//Source file: F:\jschwartz\src\Alkindi\BusinessServices\IRatingManager.java

/* Copyright (C) 2000 Alikindi, LLC */

package Alkindi.Services;

import Alkindi.Data.RatingList;
import Alkindi.Data.Rating;
import Alkindi.Data.SystemUser;
import Alkindi.Data.ProductList;
import java.rmi.RemoteException;

/* 
$Header: IRatingManager.java, 9, 12/28/00 2:50:35 PM, Schwartz, Joe$
$Log: 
 9    Alkindi Development1.8         12/28/00 2:50:35 PM  Schwartz, Joe  
      Standardized methods to use final parameters and fully-qualified types
      where necessary. Makes Rose happy.
 8    Alkindi Development1.7         12/28/00 1:07:07 PM  Schwartz, Joe   Added
      Version Control header info.
 7    Alkindi Development1.6         12/26/00 6:57:12 PM  Schwartz, Joe   
 6    Alkindi Development1.5         10/30/00 7:51:15 PM  Schwartz, Joe   
 5    Alkindi Development1.4         10/19/00 1:12:03 PM  Schwartz, Joe   After
      10.19 Appian Delivery
 4    Alkindi Development1.3         10/9/00 3:12:11 PM   Schwartz, Joe   
 3    Alkindi Development1.2         10/6/00 4:13:36 PM   Schwartz, Joe   
 2    Alkindi Development1.1         9/24/00 3:12:15 PM   Schwartz, Joe   
 1    Alkindi Development1.0         9/21/00 4:12:05 PM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * This interface facilitates the acquisition and storage of product evaluations.
 */
public interface IRatingManager 
{
	
	/**
	 * Generates a list of products for a New User to rate.
	 * @roseuid 39F6F1DD0157
	 */
	public Alkindi.Data.ProductList getInitialProductsToRate(final int numDesired) throws AlkExcept,RemoteException;
	
	/**
	 * Generates a list of products for the given SystemUser to rate.
	 * @roseuid 3999BF550242
	 */
	public Alkindi.Data.ProductList getProductsToRate(final Alkindi.Data.SystemUser user, final int numDesired) throws RemoteException,AlkExcept;
	
	/**
	 * Retrieves the ratings submitted by a particular user.
	 * @roseuid 39E1FF4E034B
	 */
	public Alkindi.Data.RatingList getUserRatings(Alkindi.Data.SystemUser user) throws AlkExcept,RemoteException;
	
	/**
	 * Stores the given Ratings.
	 * @roseuid 399DAE01037A
	 */
	public void rateProducts(final Alkindi.Data.RatingList ratings) throws RemoteException,AlkExcept;
}
